<?php
/**
 *
 * @package Support Toolkit
 * @version $Id$
 * @copyright (c) 2010 phpBB Group
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 *
 */

/**
 * @ignore
 */
if (!defined('IN_PHPBB'))
{
   exit;
}

if (empty($lang) || !is_array($lang))
{
   $lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'COMPILED_TEMPLATE_EXPLAIN'		=> 'Debajo se encuentra su copia de la Plantilla de Petición de Soporte. Haga clic debajo para copiarla a su portapapeles, luego cree un nuevo mensaje en el <a href="http://www.phpbb.com/community/viewforum.php?f=46">Foro de Soporte Oficial</a> (en inglés) con esta información. Si ya hay un tema existente en el que se esté tratando este asunto por favor copie la plantilla en un mensaje de respuesta al tema existente en vez de crear uno nuevo.',
	'COULDNT_LOAD_SRT_ANSWERS'		=> 'Generador de Plantilla de Petición de Soporte no puede cargar todas las carpetas,asegurese de que hace iniciado correctamente la herramienta',
	'SRT_GENERATOR'					=> 'Generador de Plantilla de Petición de Soporte',
	'SRT_GENERATOR_LANDING'			=> 'Generador de Plantilla de Petición de Soporte',
	'SRT_GENERATOR_LANDING_CONFIRM'	=> 'Bienvenido al Equipo de Soporte del Generador de Plantilla de Petición de Soporte. Esta es la forma más rápida y eficiente de completar nuestra Plantilla de Petición de Soporte. El generador le hará una serie de ocho a diez preguntas que son útiles para el diagnóstico de la mayoría de los temas. A continuación, genera sus respuestas en una lista que se puede copiar y pegar en el tema de ayuda.<br />Esta herramienta STK hace lo mismo que <a href="http://www.phpbb.com/support/stk/">SRT Generator on www.phpbb.com</a> pero hace preguntas previamente<br /><br />¿Desea ejecutar el Generador SRT?',
	'SRT_NO_CACHE'					=> 'La solicitud de soporte del generador de plantillas utiliza el sistema de cache para almacenar información phpBB mientras que pasa por todos los pasos. Usted está utilizando la caché nulo phpBB, las cuales no son compatibles con esta herramienta. Por favor, cambiar a uno de los backends de almacenamiento en caché para que utilicen esta herramienta o utilizar la <a href="http://www.phpbb.com/support/srt/"> línea SRT Generador </ a> ',
	'START_OVER'					=> 'Empezar de nuevo',
));

// Step 1 strings
$lang = array_merge($lang, array(
//	'STEP1_CONVERT'			=> '',
//	'STEP1_CONVERT_EXPLAIN'	=> '',
	'STEP1_MOD'				=> '¿Está su problema relacionado con algún MOD?',
	'STEP1_MOD_EXPLAIN'      => '¿Este problema comenzó después de instalar o de desinstalar un MOD?',
	'STEP1_MOD_ERROR'      => 'Preguntas de soporte para asuntos relacionados con MODs tales como si ha instalado un MOD y ahora está teniendo errores deberían ser realizadas en el tema desde donde descargó el MOD. Si el MOD fue descargado desde otro sitio, tendrá que buscar soporte ahí. 
	
	<a href="http://www.phpbb.com/community/viewforum.php?f=81">Ir al foro de MODs</a>',
	'STEP1_HACKED'         => '¿Su foro fue hackeado?',
	'STEP1_HACKED_EXPLAIN'   => 'Seleccione "Sí" para esta opción si está buscando soporte porque su foro fue desfigurado, si no comprometido.',
	'STEP1_HACKED_ERROR'   => 'Si su foro fue hackeado, le pedimos que presente un reporte con el Incident Investigation Tracker en vez de crear nuevo tema en el foro de soporte, de manera que no tenga que divulgar información privada.<br /><br />Mire <a href="http://www.phpbb.com/community/viewtopic.php?f=46&t=543171#iit">este mensaje</a> para instrucciones sobre cómo hacerlo.',
));

// The questions
$lang = array_merge($lang, array(
	'SRT_QUESTIONS'			=> array(
		'step2'	=> array(
        'phpbb_version'      => '¿Qué versión de phpBB está usando?',
        'board_url'         => '¿Cuál es la URL de su foro?',
        'host_name'         => '¿Quién es su proveedor de hospedaje (hosting)?',
		'dbms'				=> '¿Cual la version y el tipo de la base de datos?',
		'php'				=> '¿Que versión de PHP esta usando?',
        'install_type'      => '¿Cómo instaló su foro?',
        'inst_converse'      => '¿Su foro es una instalación nueva o es una conversión?',
        'mods_installed'   => '¿Tiene MODs instalados?',
        'registration_req'   => '¿El registro es obligatorio para reproducir este problema?',
      ),
      'step3'   => array(
        'installed_styles'      => '¿Qué estilos tiene instalados actualmente?',
        'installed_languages'   => '¿Qué idioma(s) está usando en su foro actualmente?',
        'xp_level'            => '¿Cuál es su nivel de experiencia?',
        'problem_started'      => '¿Cuándo comenzó su problema?',
        'problem_description'   => 'Por favor, describa su problema.',
        'installed_mods'      => '¿Qué Mods tiene instalados?',
        'test_username'         => '¿Cuál es el nombre de usuario que puede ser usado para ver este problema?',
        'test_password'         => '¿Cuál es la contraseña que puede ser usada para ver este problema?',
		),
	),
));

// Explain lines for the questions
$lang = array_merge($lang, array(
	'SRT_QUESTIONS_EXPLAIN'	=> array(
		'step2'	=> array(
		'phpbb_version'      => 'El Generador SRT no pudo determinar qué versión de phpBB está usando, por favor seleccione la versión correcta. Para encontrar esta información, identifíquese en su foro y desplácese hacia abajo hasta el fondo de la página. Haca clic en "Panel de Administración (ACP)". Haga clic en la etiqueta "Sistema".',
        'board_url'         => 'La URL de su foro es la dirección que usa para acceder a éste. La mayoría de problemas son reparados con más facilidad cuando uno puede ver su foro. Si no desea revelar esta información, por favor introduzca "n/a".',
        'host_name'         => 'Algunos problemas experimentados con foros phpBB pueden atribuirse a ciertos proveedores de hospedaje en particular. Este campo debe ser rellenado con la compañía que le está proveyendo su paquete de webhosting (por ejemplo GoDaddy, Yahoo!, 1&1, etc.). Si se provee su propio hosting para el foro, por favor indíquelo. También, si no sabe quién es el proveedor de hosting de su foro, por favor indíquelo de igual manera.',
		'dbms'               => 'Para determinar qué versión y tipo de base de datos está usando, vaya al Panel de Administración (ACP). En la etiqueta "General", localice "Servidor de base de datos:" en la tabla de estadísticas.',
        'install_type'      => 'Si instaló su foro descargando los archivos phpBB, subiéndolos a su servidor, después dirigiendo su navegador al instalador, seleccione “He instalado el foro yo mismo.” Si otra persona realizó la instalación por usted seleccione “Otra persona instaló el foro por mí.” Si utilizó una herramienta automatizada como Fantastico, seleccione “Utilicé una herramienta proporcionada por mi hospedaje.”',
        'inst_converse'      => 'Si su foro es una instalación nueva, esto significa que su foro no existía antes de instalarlo con phpBB. Si actualizó recientemente su foro desde una versión anterior de phpBB3 antes de que su problema comenzara, entonces seleccione "Actualización desde una versión previa de phpBB3". Si esta es una conversión, eso significa que su foro fue instalado previamente con otra pieza de software y más tarde fue convertida a phpBB.',
        'mods_installed'   => 'Los MODs a menudo son la causa de muchos problemas con phpBB. Esta información puede ayudar a determinar la causa exacta de su problema.',
		'php' => 'Para determinar qué versión de PHP está utilizando, vaya al Panel de Control de Administración. En la pestaña "General", haga clic en "Información de PHP", aquí usted encontrará "PHP versión xyz" ',
        'registration_req'   => 'Seleccione "Sí", si uno debe estar registrado e identificado para experimentar el problema.',
      ),
      'step3'   => array(
        'installed_styles'      => 'Un estilo desactualizado es la causa de muchos problemas. Si no sabe qué estilos tiene instalados, vaya al Panel de Administración (ACP), después diríjase a la etiqueta "Estilos".',
        'installed_languages'   => 'Un paquete de idiomas desactualizado es la causa de muchos problemas. Si no sabe qué paquetes de idiomas tiene instalados, vaya al Panel de Administración (ACP), después diríjase a la etiqueta "Sistema". Lo siguiente es seleccionar "Paquetes de idiomas" de la lista de páginas a la izquierda.',
        'xp_level'            => 'Por favor, seleccione la opción que mejor describa su nivel de experiencia.',
        'problem_started'      => 'Por favor, describa las acciones que tomó (actualización de su foro, instalación de un MOD, etc.) antes de que el problema se manifestara.',
        'problem_description'   => 'Cuando esté describiendo su problema, por favor intente ser lo más detallado posible. Incluya información con respecto a cuándo comenzó el problema, pasos a seguir para reproducirlo, y cualquier otra información que considere útil.',
        'installed_mods'      => 'Por favor, intente ser lo más detallado posible cuando proporcione la lista de los MODs instalados. Esta información nos ayuda grandemente para determinar la causa de su problema.',
        'test_username'         => 'Por favor, proporcione el nombre de usuario para una cuenta de prueba que pueda ser utilizada para ver este problema. <strong>No</strong> proporcione esta información si el usuario requiere de más privilegios que los de un "usuario normal".',
        'test_password'         => 'Por favor, proporcione la contraseña para una cuenta de prueba que pueda ser utilizada para ver este problema. <strong>No</strong> proporcione esta información si el usuario requiere de más privilegios que los de un "usuario normal".',
		),
	),
));

// Langauge strings that are used for building dropdown boxes
$lang = array_merge($lang, array(
	'SRT_DROPDOWN_OPTIONS'	=> array(
		'step2'	=> array(
			'install_type'	=> array(
			null			=> 'Por favor seleccione un respuesta',
				'myself'		=> 'Utilicé el paquete de descarga de phpBB.com',
				'third'			=> 'Utilicé un paquete de descarga proporcionado por otro sitio web',
				'someone_else'	=> 'Otra persona instaló el foro por mí',
				'automated'		=> 'Utilicé una herramienta proporcionada por mi hospedaje',
			),
			'inst_converse'	=> array(
			null			=> 'Por favor seleccione una respuesta',
				'fresh'				=> 'Instalación nueva',
				'phpbb_update'		=> 'Actualización desde una versión previa de phpBB3',
				'convert_phpbb2'	=> 'Conversión de phpBB2',
				'convert_other'		=> 'Conversión de otro software (SMF, Invision, etc...)',
			)
		),
		'step3'	=> array(
			'xp_level'		=> array(
			null			=> 'Por favor seleccione una respuesta',
				'new_both'		=> 'Nuevo con PHP y phpBB',
				'new_phpbb'		=> 'Nuevo con phpBB pero no con PHP',
				'new_php'		=> 'Nuevo con PHP pero no con phpBB',
				'comfort'		=> 'Cómodo con PHP y phpBB',
				'experienced'	=> 'Experimentado con PHP y phpBB',
			),
		),
	),
));